﻿/*	VERSION:  1.3

USAGE:
	#include "functions/applyCondition.as"
	var condition = "RAM.myObj.myvar = 47";
	applyCondition( condition );

DESCRIPTION:
	Sets a variable, based on a string.
*/
//#include "getPathValue.as"
//#include "getImpliedValue.as"
#include "nestedEval.as"
// set a variable, based on a condition  (string or variable)
applyCondition = function( input, defaultContainer_str, thisName )
{
	if( typeof(input)=="string" ){
		applyConditionStr( input, defaultContainer_str, thisName );
	}
	else if( typeof(input)=="object" ){
		applyConditionVar( input, defaultContainer_str, thisName );
	}
}// applyCondition()





// set a variable, based on a condition object
applyConditionVar = function( condition, defaultContainer_str, thisName )
{
	var defaultContainer_str = (defaultContainer_str) ? defaultContainer_str : "RAM";
	// resolve target variable
	var target_str = nestedEval(condition[0], defaultContainer_str, thisName);
	var divideAt = target_str.lastIndexOf(".");
	if(divideAt==-1)
	{// if:  not a variable path  (single variable)
		// assume this single variable exists within RAM
		var varContainerName = defaultContainer_str;
		var varContainer = resolveContainer(defaultContainer_str);
	}// if:  not a variable path  (single variable)
	else
	{// if:  is a variable path
		// determine the intended container
		var varContainerName = target_str.substr(0,divideAt);
		var varContainer = evalPath( varContainerName, defaultContainer_str, thisName );
	}// if:  is a variable path
	var varName = target_str.substr(divideAt+1);
	
	// resolve value  &  optionally create objects
	var operationDone = false;
	//var thisValue = getImpliedValue(condition[2]);		// convert string to appropriate datatype if neccessary
	var thisValue = getImpliedValue(condition[2]);		// convert string to appropriate datatype if neccessary
	if(thisValue == "\\object"){
		// create new object
		varContainer[varName] = {};
		var operationDone = true;
	}else if(thisValue=="\\delete"){
		varContainer[varName] = undefined;
		delete varContainer[varName];
		var operationDone = true;
	}
	
	// parse any variable paths
	var value = nestedEval( thisValue, defaultContainer_str, thisName );
	
	// apply operation
	if( !operationDone )
	{
		switch( condition[1] )
		{
			case "!=":
				if(value == undefined){
					if(!varContainer[varName]){
						varContainer[varName] = !value;
					}
				}else{
					varContainer[varName] = !value;
				}
			break;
			case "=":
				varContainer[varName] = value;
			break;
			case "+":
				var bothAreNumbers = (!isNaN(varContainer[varName])) && (!isNaN(value));
				if(bothAreNumbers){
					varContainer[varName] = Number(varContainer[varName]) + Number(value);
				}else{
					varContainer[varName] = String(varContainer[varName]) + String(value);
				}
			break;
			case "-":
				varContainer[varName] -= value;
			break;
			case "*":
				varContainer[varName] *= value;
			break;
			case "/":
				if(value==0){
					varContainer[varName] = undefined;
				}else{
					varContainer[varName] /= value;
				}
			break;
			case "%":
				if(value==0){
					varContainer[varName] = undefined;
				}else{
					varContainer[varName] %= value;
				}
			break;
		}// switch:  operator
		
		
		// catch NaN
		if( typeof(varContainer[varName])=="number"  &&  isNaN(varContainer[varName]) )
			varContainer[varName] = undefined;
	}// if:  not a special operation, such as deleting or creating objects
}// applyConditionVar()





// set a variable, based on a condition string
applyConditionStr = function( input, defaultContainer_str, thisName )
{
	var conditionVar = makeConditionVar( input );
	applyConditionVar( conditionVar, defaultContainer_str, thisName );
}// applyConditionStr()





// convert condition string  ->  condition variable
makeConditionVar = function( input )
{
	var parts_array = new Array(3);
	
	// remove space from beginning of input
	var firstChar = input.charAt(0);
	while(firstChar==" "){
		input = input.substr(1);		// chop off first character
		firstChar = input.charAt(0);
	}// while:  space exists at the beginning
	
	
	// remove space from end of input
	var lastChar = input.charAt( input.length-1 );
	while(lastChar==" "){
		input = input.substr(0, input.length-1);		// chop off last character
		lastChar = input.charAt( input.length-1 );
	}// while:  space exists at the end
	
	
	// catch:  !myinput
	if( input.charAt(0) == "!" ){
		input = input.substr(1)+"=undefined";
	}// if:  input starts with !
	
	if( input.indexOf("!=") != -1 ){
		var endAt = input.indexOf("!=");
		var startAt = endAt+2;
	}
	else if( input.indexOf("<=") != -1 ){
		var endAt = input.indexOf("<=");
		var startAt = endAt+2;
	}
	else if( input.indexOf(">=") != -1 ){
		var endAt = input.indexOf(">=");
		var startAt = endAt+2;
	}
	else if( input.indexOf("<") != -1 ){
		var endAt = input.indexOf("<");
		var startAt = endAt+1;
	}
	else if( input.indexOf(">") != -1 ){
		var endAt = input.indexOf(">");
		var startAt = endAt+1;
	}
	else if( input.indexOf("=") != -1 ){
		var endAt = input.indexOf("=");
		var startAt = endAt+1;
	}
	else{// if:  there's no operator
		var endAt = input.length;
		input = input+"!=undefined"
		var startAt = endAt+2;
	}// if:  there's no operator
	
	parts_array[0] = input.substr( 0, endAt );					// [0]	myinput
	parts_array[1] = input.substring( endAt, startAt );	// [1]	!=
	parts_array[2] = input.substr( startAt );						// [2]	"merf"
	
	// remove space from end of input name
	var lastChar = parts_array[0].charAt( parts_array[0].length-1 );
	while(lastChar==" "){
		parts_array[0] = parts_array[0].substr(0, parts_array[0].length-1);		// chop off last character
		lastChar = parts_array[0].charAt( parts_array[0].length-1 );
	}// while:  space exists at the end
	// remove space from beginning of value
	var firstChar = parts_array[2].charAt(0);
	while(firstChar==" "){
		parts_array[2] = parts_array[2].substr(1);		// chop off first character
		firstChar = parts_array[2].charAt(0);
	}// while:  space exists at the beginning
	
	return parts_array;
}// getConditionVar()





// convert condition variable  ->  condition string
makeConditionStr = function( input )
{
	var output = "";
	if(input[1]=="!="  &&  input[2]=="undefined")
	{// if:  !var
		output = "!"+input[0];
	}// if:  !var
	else
	{// if:  normal
		output = input[0] +input[1] +input[2];
	}// if:  normal
	return output;
}// getConditionStr()
